
/**********************Document Ready****************************************/

$(document).ready(function(){
    
    
    /*******************local time****************************************/
    
    let regionNames = new Intl.DisplayNames(['en'], {type: 'region'});
    
    const convertTime12to24 = time12h => {const [time, modifier] = time12h.split(" ");let [hours, minutes] = time.split(":");if (hours === "12") {hours = "00";}if (modifier === "PM") {hours = parseInt(hours, 10) + 12;}return `${hours}:${minutes}`;};
    
    function refreshTime() {
      const timeDisplay = document.getElementById("realtime");
      const dateString = new Date().toLocaleTimeString();
      const formattedString = dateString.replace(", ", " - ");
      timeDisplay.textContent = formattedString;
    }   
    setInterval(refreshTime, 1000);
    
    /***************************state selection***************************/
    
    let user_country_code = "AF";
    
    //let country_list = country_and_states['country'];
    let states_list = country_and_states['states'];
    
    create_states_dropdown(user_country_code);
    
    $urldetails = $(location).attr('href');
    $searchd = "personalprofile";
    if($urldetails.indexOf($searchd) != -1){
        $('#sCountry').on("change", function(){
          var countrycode = $(this).val();
          create_states_dropdown(countrycode);
          select_currency(countrycode)
        });
    }else{
        $('#country').on("change", function(){
          var countrycode = $(this).val();
          create_states_dropdown(countrycode);
          select_currency(countrycode)
        });
    }
    
    /*************************get time*************************************/
    
    function gettimeclock(){
        $gettimezone = $("#time_zone option:selected").val();
        var Timenow = new Date();
        if(($gettimezone !== "") && ($gettimezone != "Choose")){
            newtime = Timenow.toLocaleString('en-US', { timeZone: $gettimezone });
        }else{
            const timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
            newtime = Timenow.toLocaleString('en-US', { timeZone: timezone });
        }
        const localtime = newtime.split(", ");
        const newtimedetails = localtime[0]+" "+localtime[1];
        return newtimedetails;
        //gettimeaspertimezone(newtimedetails);
    }
    
    function gettimeaspertimezone(){
        /* Analog Clock */
        // for time;
        const deg = 6; 
        // 360 / (12 * 5);
        const hr = document.querySelector('#hr');
        const mn = document.querySelector('#mn');
        const sc = document.querySelector('#sc');
        setInterval(() => {
            let day = new Date(newtime);
            let hh = day.getHours() * 30;
            let mm = day.getMinutes() * deg;
            let ss = day.getSeconds() * deg;
            let msec = day.getMilliseconds();
            
            // VERY IMPORTANT STEP:
            hr.style.transform = `rotateZ(${(hh) + (mm / 12)}deg)`;
            mn.style.transform = `rotateZ(${mm}deg)`;
            sc.style.transform = `rotateZ(${ss}deg)`;
            // gives the smooth transitioning effect, but there's a bug here!
            // sc.style.transition = `1s`;
        });
        
        /* Digital Clock*/ 
        var $hOut = $('#hours'),
            $mOut = $('#minutes'),
            $ampmOut = $('#ampm');
        function update(){
            newtime = gettimeclock();
            var date = new Date(newtime);
            var ampm = date.getHours() < 12
                        ? 'AM'
                        : 'PM';
            var hours = date.getHours() == 0
                        ? 12
                        : date.getHours() > 12
                            ? date.getHours() - 12
                            : date.getHours();
            
            var minutes = date.getMinutes() < 10 
                            ? '0' + date.getMinutes() 
                            : date.getMinutes();
            $hOut.text(hours);
            $mOut.text(minutes);
            $ampmOut.text(ampm);
        } 
        update();
        window.setInterval(update, 1000);       
    }
    
    
    /********************function state selection***************************/

    function create_states_dropdown(countrycode) {
        let states = states_list[countrycode];
        let option = '';
        $('#state-code').empty();
        if (states.length > 0) {
            $('#state-code').append('<option value="Choose">Choose State/Region</option>');
            for (let i = 0; i < states.length; i++) {
                $('#state-code').append('<option value="' + states[i].code + '">' + states[i].name + '</option>');
            }
        } else {
            $('#state-code').append('<option value="nooption">No State/Region Available</option>');
        }
        $('.countrypicker').selectpicker('refresh');
        $('.select-state_region').selectpicker('refresh');
    }
    
    /********************function currency selection***************************/
    
    function select_currency(countrycode) {
        $("#currency option").attr("selected", false);
        $("#time_zone option").attr('selected', false);
        if(countrycode == "IN"){
            $currencycode = "INR";
            $timezone = "Asia/Calcutta";
        }else if(countrycode == "GB"){
            $currencycode = "GBP";
            $timezone = "Europe/London";
        }else if(countrycode == "GH"){
            $currencycode = "GHS";
            $timezone = "Africa/Accra";
        }else if(countrycode == "US"){
            $currencycode = "USD";
            $timezone = "America/New_York";
        }else if(countrycode == "CA"){
            $currencycode = "CAD";
            $timezone = "Canada/Eastern";
        }else{
            $currencycode = "Choose";
            $timezone = "Choose";
        }
        $("#currency option[value='"+$currencycode+"']").attr('selected', 'selected');
        $("#time_zone option[value='"+$timezone+"']").attr('selected', 'selected');
        $('.currencyd').selectpicker('refresh');
        $('.select-time_zone').selectpicker('refresh');
    }
    
    /************************submit site config***************************/
     
     $("#sitesetup").on("submit",function(e){
        e.preventDefault();
        var form_data = new FormData(this);
        form_data.append("typed","insertupdate");
        sitedetails(form_data);
     });
    
    /********************function site config***************************/
    
    function sitedetails(formdata){
        $.ajax({
                url: "assets/php/siteconfigurationdetails.php",
                method:"POST",
                data:formdata,
                dataType:"JSON",
                processData:false,
                contentType:false,
                success:function(data){
                    $(".amsg").text(data);
                    if(data == "Information Registered!" || data == "Information Updated!"){
                        $("html").scrollTop(0);
                        $('.amsg').css({"color":"green"});
                        window.location.reload();
                        selectalldetails();
                    }
                }
        });
    }
    
    /********************function select all details***************************/
    
    selectalldetails();
    
    function selectalldetails(){
        $.ajax({
                url: "assets/php/siteconfigurationdetails.php",
                method:"POST",
                data:{alldetails:"getalldetails"},
                dataType:"JSON",
                success:function(data){
                     $("#country option[value='"+data['pcountry']+"']").attr('selected', 'selected');
                     create_states_dropdown(data['pcountry']);
                     $("#state-code option[value='"+data['pstate']+"']").attr('selected', 'selected');
                     $("#time_zone option[value='"+data['ptimezone']+"']").attr('selected', 'selected');
                     $("#currency option[value='"+data['pcurrencytype']+"']").attr('selected', 'selected');
                     if(data['whatsapp'] == "on"){
                          $('input[name="whatsapp"]').prop('checked', true);
                     }
                     if(data['email'] == "on"){
                          $('input[name="Email"]').prop('checked', true);
                     }
                     if(data['phone'] == "on"){
                          $('input[name="Phone"]').prop('checked', true);
                     }
                     $('.currencyd').selectpicker('refresh');
                     $('.countrypicker').selectpicker('refresh');
                     $('.select-state_region').selectpicker('refresh');
                     $('.select-time_zone').selectpicker('refresh');
                     gettimeaspertimezone();
                }
        });
    }
});