
/**********************Document Ready****************************************/

$(document).ready(function(){
    
    /*****************************Graph Data*********************************/
    
    var today = new Date();
    var tday= today.getFullYear();
    $('.sSignups').text(tday);
    //getAllStudentdetails();
    
    $urldetails = $(location).attr('href');
    $searchd = "admin/dashboard";
    
    if($urldetails.indexOf($searchd) != -1){
        $yeard = $('.sSignups').text();
        getAllStudentdetails($yeard);
        getAllSource();
        getAllRevenueByCourse();
        getAllTeacher();
        getAllStudent();
        getAllProspect();
        getteacherrating();
        getstudentrating();
        gettotalrevenue();
        
        /*****************************Go to Event*************************/
        
        $('.leftclick').on("click",function(){
            var prevyear = $('.sSignups').text();
            $('.sSignups').text(parseInt(prevyear)-1);
            $yeard = $('.sSignups').text();
            getAllStudentdetails($yeard);
        });
        
        /*****************************Prospect Click*************************/
        
        $('.rightclick').on("click",function(){
            var nextyear = $('.sSignups').text();
            $('.sSignups').text(parseInt(nextyear)+1);
            $yeard = $('.sSignups').text();
            getAllStudentdetails($yeard);
        });
    
    }else{
        getAllSource();
        getAllRevenueByCourse();
    }
    
    function displaygraph(xlabels,ylabels,typed,catdetails){    
        var ctx = document.getElementById("assignment_performance").getContext('2d');
        const assignment_performance = new Chart(ctx, {
            type: 'bar',
            data: {
            //["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
            labels: xlabels,
            datasets: [{
                    label: catdetails,
                    data: ylabels,
                    backgroundColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(74, 173, 33, 1)',
                    'rgba(255, 159, 64, 1)',
                    'rgba(230, 238, 52, 1)',
                    'rgba(33, 215, 139, 1)',
                    'rgba(191, 0, 255, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(132, 99, 255, 1)',
                    'rgba(241, 31, 81, 1)'
                    ],
                    borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(74, 173, 33, 1)',
                    'rgba(255, 159, 64, 1)',
                    'rgba(230, 238, 52, 1)',
                    'rgba(33, 215, 139, 1)',
                    'rgba(191, 0, 255, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(132, 99, 255, 1)',
                    'rgba(241, 31, 81, 1)'
                    ],
                    borderWidth: 1
            }]
            },
            options: {
                scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true,
                        suggestedMin: 0,
                        suggestedMax: 100
                    }
                }],
                xAxes: [
                    {
                    barThickness: 14,  // number (pixels) or 'flex'
                    maxBarThickness: 14, // number (pixels)
                    barPercentage: 0.5,
                    },
                ]
                },
                legend: {
                  position: 'top',
                  labels: {
                    padding: 20,
                    boxWidth: 10
                  }
                }
            }
            });
    }
    
    
    function displayratio(name,count,colors){
        var ctxP = document.getElementById("pieChart").getContext('2d');
        ctxP.width = 1000;
        ctxP.height = 1000;
        var myPieChart = new Chart(ctxP, {
        type: 'pie',
        radius: "90%",
        plugins: [ChartDataLabels],
        data: {
            datasets: [{
                data: count,
                backgroundColor: ["#F7464A", "#46BFBD", "#FDB45C", "#949FB1", "#4D5360"],
                hoverBackgroundColor: ["#FF5A5E", "#5AD3D1", "#FFC870", "#A8B3C5", "#616774"]
            }],
            labels: name
        },
        options: {
            responsive: true,
            aspectRatio: 1.1,
            //maintainAspectRatio: false,
            legend: {
              position: 'bottom'
            },
            plugins: {
                  datalabels: {
                    formatter: (value, ctx) => {
                      let sum = 0;
                      let dataArr = ctx.chart.data.datasets[0].data;
                      dataArr.map(data => {
                        sum += data;
                      });
                      let percentage = Math.round((value * 100 / sum).toFixed(2)) + "%";
                      return percentage;
                    },
                    color: 'white',
                    labels: {
                      title: {
                        font: {
                          size: '16'
                        }
                      }
                    }
                  }
                }
        }
        });
    }
    
    function getteacherrating(){
        $actiontype = "Teacher Rating";
        ratingaction($actiontype);
    }
    
    function getstudentrating(){
        $actiontype = "Student Rating";
        ratingaction($actiontype);
    }
    
    function ratingaction($actiontype){
        $.ajax({
            url: "assets/php/dashboarddetails.php",
            method:"POST",
            dataType:"json",
            data:{
                "type":$actiontype
            },
            success:function(data){
                if($actiontype == "Teacher Rating"){
                    $.each(data,function(i,row){
                       $actualpath = '../admin/assets/uploads/'+row[6]+'/'+row[5];
                       $defaultpath = '../admin/assets/img/adminAllNew/profiletemplate.jpeg';
                       if(row[5] != ""){
                           $path = checkstatus($actualpath,$defaultpath);
                       }else{
                           $path = '../admin/assets/img/adminAllNew/profiletemplate.jpeg';
                       }
                        $datesplit = row[3].split("-");
                        $('.allBestTeachers').append(
                            '<div class="media mb-3">'+
                                '<div class="media-left media-middle"> <img src="'+$path+'" class="media-object"> </div>'+
                                '<div class="media-body">'+
                                    '<h6 class="media-heading">'+row[1]+" "+row[2]+'</h6>'+
                                    '<p><strong>Subject:</strong> '+row[4]+'</p>'+
                                    // '<p><strong>Date joined:</strong> '+$datesplit[2]+"-"+$datesplit[1]+"-"+$datesplit[0]+'</p>'+
                                '</div>'+
                            '</div>'
                        );
                    });
                }else if($actiontype == "Student Rating"){
                    $.each(data,function(i,row){
                        // $actualpath = '/assets/uploads/'+row[6]+'/'+row[5];
                        // $defaultpath = '../admin/assets/img/adminAllNew/fileimage.png';
                        // if($coursepic != ""){
                        //     $path = checkstatus($actualpath,$defaultpath);
                        // }else{
                        //     $path = '../admin/assets/img/adminAllNew/fileimage.png';
                        // }
                        $datesplit = row[1].split("-");
                        $('.allBestStudent').append(
                            '<div class="media mb-3">'+
                                '<div class="media-left media-middle"> <img src="assets/img/best-teachers.png" class="media-object"> </div>'+
                                '<div class="media-body">'+
                                    '<h6 class="media-heading">'+$datesplit[0]+'</h6>'+
                                    '<p><strong>Punctuality:</strong> '+row[0]+'%</p>'+
                                    '<p><strong>Student ID:</strong> '+$datesplit[1]+'</p>'+
                                '</div>'+
                            '</div>'
                        );
                    });   
                }
            },
            error:function(data){
                
            }
        });
    }
    
    function gettotalrevenue(){
        $type = "Total Revenue";
        $.ajax({
            url: "assets/php/dashboarddetails.php",
            method:"POST",
            dataType:"json",
            data:{
                "type":$type
            },
            success:function(data){
                $('.totalRevenue').text(data);
            }
        });  
    }
    
    
     /*************************Path Check**************************************/

        function checkstatus(path,defaultpath){
            var http = new XMLHttpRequest();
            http.open('HEAD', path, false);
            http.send();
            $statuscheck = http.status;
            if($statuscheck == "200"){
              $path = path;
            }else{
              $path = defaultpath;
            }
            return $path;
        }
    
    // /*****************************3d graph********************************/
    
    //  google.charts.load('current', {'packages':['corechart']});
    //   google.charts.setOnLoadCallback(drawChart);

    //   function drawChart() {

    //     var data = google.visualization.arrayToDataTable([
    //       ['Task', 'Hours per Day'],
    //       ['Study',     11],
    //       ['Playing',      2],
    //       ['Watch TV',  2],
    //       ['Tution', 2],
    //       ['Sleep',  7]
    //     ]);

    //     var options = {
    //       //title: 'My Day Schedule',
    //       aspectRatio: 2,
    //       backgroundColor: "",
    //       pieStartAngle: 135,
    //       sliceVisibilityThreshold: .05,
    //       pieHole:100,
    //       is3D:true
    //     };

    //     var chart = new google.visualization.PieChart(document.getElementById('piechart3d'));

    //     chart.draw(data, options);
    //   }
    /*****************************3d graph********************************/
    
//     function LoadGoogle(){
//   google.charts.load('current', {
//     callback: drawChart,
//     packages:['corechart']
//   });

//   function drawChart() {
//     var data = new google.visualization.DataTable();
//     data.addColumn('string', 'Topping');
//     data.addColumn('number', 'Slices');
//     data.addRows([
//       ['Mushrooms', 3],
//       ['Onions', 1],
//       ['Olives', 1],
//       ['Zucchini', 1],
//       ['Pepperoni', 2]
//     ]);

//     var options = {'title':'How Much Pizza I Ate Last Night',
//                   'width':400,
//                   'height':300};

//     var chart = new google.visualization.BarChart(document.getElementById('piechart3d'));
//     chart.draw(data, options);
//   }
// }

// LoadGoogle();


    /**************************revenue by course graph********************/
    
    //courcerevenue();
    function courcerevenue(name,count,colors){
        var ctxd = document.getElementById("newpiechart").getContext('2d');
        //ctxd.width = 1000;
        //ctxd.height = 1000;
        var mydonutChart = new Chart(ctxd, {
            type: "doughnut",
            plugins: [ChartDataLabels],
              data: {
                labels: name,
                datasets: [{
                  backgroundColor: ["#2F9599","#EC2049","#F26B38","#F7DB4F","#A7226E"],
                  data: count
                }]
              },
              options: {
                responsive: true,
                cutoutPercentage: 50,
                //hoverOffset: 4,
                legend: {
                      position: 'bottom'
                    },
                aspectRatio: 0.9,
                //cutout:100,
                radius:80,
                //circumference:20,
                title: {
                  display: true,
                  //text: "World Wide Wine Production 2018"
                },
                plugins: {
                  datalabels: {
                    formatter: (value, ctx) => {
                      let sum = 0;
                      let dataArr = ctx.chart.data.datasets[0].data;
                      dataArr.map(data => {
                        sum += data;
                      });
                      let percentage = Math.round((value * 100 / sum).toFixed(2)) + "%";
                      return percentage;
                    },
                    color: 'white',
                    labels: {
                      title: {
                        font: {
                          size: '16'
                        }
                      }
                    }
                  }
                }
              }
        });
    }
      
      
    /*****************************Display student*************************/
    
    function getAllStudentdetails($yeard){
        const xlabels=[];
        const ylabels=[];
        $type = "Student";
        //$yeard = $('.sSignups').text();
        $.ajax({
            url: "assets/php/preport.php",
            method:"POST",
            dataType:"json",
            data:{"type":$type,
                "yeard":$yeard
            },
            success:function(data){
                $.each(data,function(i,row){
                    $.each(row,function(id,rowd){
                        $monthd = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                        $month = $monthd[id];
                        xlabels.push($month);
                        $prospectd = rowd;
                        ylabels.push($prospectd);
                        $typed = "student_performance";
                        $type = 'Student';
                        displaygraph($monthd,ylabels,$typed,$type);
                        //console.log($month+":"+$prospectd);
                    });
                });
            },
            error:function(data){
            }
        });
    }
    
    /*****************************Display source*************************/
    
    //getAllSource();
    function getAllSource(){
        const xlabels=[];
        const ylabels=[];
        const colors=[];
        const newpercentage=[];
        $type = "Student Source";
        $.ajax({
            url: "assets/php/preport.php",
            method:"POST",
            dataType:"json",
            data:{"typed":$type},
            success:function(data){
                var sum = 0;
                $.each(data,function(i,row){
                        $name = row[0]+'(%)';
                        $count = row[1];
                        xlabels.push($name);
                        ylabels.push($count);
                        sum += parseInt($count);
                        $typed = "student_performance";
                        $type = 'Student';
                        // console.log(xlabels+":"+ylabels);
                        var dynamicColors = function() {
                            var r = Math.floor(Math.random() * 255);
                            var g = Math.floor(Math.random() * 255);
                            var b = Math.floor(Math.random() * 255);
                            return "rgb(" + r + "," + g + "," + b + ")";
                         };
                        colors.push(dynamicColors);
                });
                for($i = 0;$i<ylabels.length;$i++){
                    var percentage = parseInt((ylabels[$i]/sum)*100);
                    newpercentage.push(percentage);
                }
                displayratio(xlabels,newpercentage,colors);
            },
            error:function(data){
            }
        });
    }
    
    /*****************************Display source*************************/
    
    //getAllRevenueByCourse();
    function getAllRevenueByCourse(){
        const xlabels=[];
        const ylabels=[];
        const newpercentage=[];
        const colors=[];
        $type = "Course Source";
        $.ajax({
            url: "assets/php/preport.php",
            method:"POST",
            dataType:"json",
            data:{"typed":$type},
            success:function(data){
                var sum = 0;
                $.each(data,function(i,row){
                        $name = row[0]+'(%)';
                        $count = row[1];
                        xlabels.push($name);
                        ylabels.push($count);
                        sum += parseInt($count);
                        $typed = "student_performance";
                        $type = 'Student';
                        // console.log(xlabels+":"+ylabels);
                        var dynamicColors = function() {
                            var r = Math.floor(Math.random() * 255);
                            var g = Math.floor(Math.random() * 255);
                            var b = Math.floor(Math.random() * 255);
                            return "rgb(" + r + "," + g + "," + b + ")";
                         };
                        colors.push(dynamicColors);
                });
                for($i = 0;$i<ylabels.length;$i++){
                    var percentage = parseInt((ylabels[$i]/sum)*100);
                    newpercentage.push(percentage);
                }
                courcerevenue(xlabels,newpercentage,colors);
                //displayratio(xlabels,ylabels,colors);
            },
            error:function(data){
            }
        });
    }
        
    /*****************************Display Teacher*************************/
    
    //getAllTeacher();
    function getAllTeacher(){
        $type = "AdminDashboard";
        $.ajax({
            url: "assets/php/dashboarddetails.php",
            method:"POST",
            dataType:"json",
            data:{"type":$type},
            success:function(data){
                $('#teachercount').text(data);
            },
            error:function(data){
            }
        });
    }
    
    /*****************************Display Student*************************/
    
    //getAllStudent();
    function getAllStudent(){
        $type = "Student";
        $.ajax({
            url: "assets/php/dashboarddetails.php",
            method:"POST",
            dataType:"json",
            data:{"type":$type},
            success:function(data){
                $('#studentcount').text(data);
            },
            error:function(data){
            }
        });
    }
    
    /*****************************Display Prospect*************************/
    
    //getAllProspect();
    function getAllProspect(){
        $yeard = $('.sSignups').text();
        $type = "Prospect";
        $.ajax({
            url: "assets/php/dashboarddetails.php",
            method:"POST",
            dataType:"json",
            data:{
                "type": $type,
                "yeard": $yeard
            },
            success:function(data){
                $('#prospectcount').text(data);
            },
            error:function(data){
            }
        });
    }
    
    

    /*****************************Go to Event*************************/
    
    $('.addevent').on("click",function(){
        $(location).prop('href', 'upcomingevents');
    });
    
    /*****************************Prospect Click*************************/
    
    $('#allprospects').on("click",function(){
        $(location).prop('href', 'viewprospect');
    });
    
    /*****************************Student Click*************************/
    
    $('#allstudents').on("click",function(){
        $(location).prop('href', 'viewstudent');
    });
    
    /*****************************Teacher Click*************************/
    
    $('#allteachers').on("click",function(){
        $(location).prop('href', 'viewteacher');
    });
    
    
                                             
});